/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ptmp.impl;

import com.cisco.pt.LTV;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.impl.OptionsManager;
import com.cisco.pt.ipc.events.IPCEventManager;
import com.cisco.pt.ptmp.ConnectionNegotiationProperties;
import com.cisco.pt.ptmp.PacketTracerConnection;
import com.cisco.pt.ptmp.PacketTracerReadWorker;
import com.cisco.pt.ptmp.PacketTracerSession;
import com.cisco.pt.ptmp.Pipeline;
import com.cisco.pt.ptmp.impl.PacketTracerConnectionImpl;
import com.cisco.pt.ptmp.impl.PacketTracerReadWorkerImpl;
import com.cisco.pt.ptmp.impl.PipelineImpl;
import com.cisco.pt.ptmp.task.AuthenticationTask;
import com.cisco.pt.ptmp.task.ConnectionNegotiationTask;
import com.cisco.pt.ptmp.task.DisconnectTask;
import com.cisco.pt.ptmp.task.KeepAliveTask;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PacketTracerSessionImpl
implements PacketTracerSession {
    private static Log logger = LogFactory.getLog(PacketTracerSessionImpl.class);
    private PacketTracerConnection packetTracerConnection;
    private Pipeline pipeline;
    private PacketTracerReadWorker readWorker;
    private IPCEventManager eventManager;
    private Timer timer;
    private long sessionID;
    protected boolean isShutdown = false;
    protected int readErrorCount = 0;
    protected KeepAliveTask keepAliveTask = null;

    public PacketTracerSessionImpl(String host, int port) throws IOException {
        this(host, port, OptionsManager.getInstance().getConnectOpts());
    }

    public PacketTracerSessionImpl(String host, int port, ConnectionNegotiationProperties connectionNegotiationProperties) throws IOException {
        try {
            this.sessionID = System.nanoTime();
            this.packetTracerConnection = new PacketTracerConnectionImpl(host, port, connectionNegotiationProperties);
            if (!this.packetTracerConnection.connect()) {
                throw new Error("Unable to connect to Packet Tracer", this.packetTracerConnection.getCurrentStatusThrowable());
            }
            ConnectionNegotiationTask connectionNegotiationTask = new ConnectionNegotiationTask(this.packetTracerConnection);
            connectionNegotiationTask.negotiateConnection();
            this.packetTracerConnection.connectLowLevelReadThread();
            this.pipeline = new PipelineImpl(this.packetTracerConnection);
            AuthenticationTask authenticationTask = new AuthenticationTask(this);
            boolean success = authenticationTask.authenticate();
            if (success) {
                this.timer = new Timer(Long.toString(this.sessionID));
                this.keepAliveTask = new KeepAliveTask(this);
                this.timer.schedule((TimerTask)this.keepAliveTask, KeepAliveTask.KEEP_ALIVE_INTERVAL, (long)KeepAliveTask.KEEP_ALIVE_INTERVAL);
                this.eventManager = new IPCEventManager(this);
                this.readWorker = new PacketTracerReadWorkerImpl(this, this.pipeline);
                this.readWorker.start();
                this.eventManager.start();
            } else {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)"Authentication failed.");
                    logger.warn((Object)"Attempting to disconnecting from Packet Tracer.");
                }
                logger.info((Object)"Closing");
                this.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public void close() throws IOException {
        if (this.readWorker != null) {
            this.readWorker.shouldStop();
            this.readWorker = null;
        }
        if (this.eventManager != null) {
            this.eventManager.interrupt();
            this.eventManager = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        DisconnectTask disconnectTask = new DisconnectTask(this);
        try {
            disconnectTask.disconnect();
        }
        catch (IOException e) {
            logger.info((Object)"Failed to sending disconnect message.", (Throwable)e);
        }
        if (this.packetTracerConnection != null) {
            this.packetTracerConnection.disconnect();
            this.packetTracerConnection = null;
        }
        this.isShutdown = true;
    }

    protected void emergencyShutdown() {
        block5: {
            try {
                this.isShutdown = true;
                if (this.readWorker != null) {
                    this.readWorker.shouldStop();
                    this.readWorker = null;
                }
                if (this.timer != null) {
                    this.timer.cancel();
                }
                if (this.packetTracerConnection != null) {
                    this.packetTracerConnection.disconnect();
                    this.packetTracerConnection = null;
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) break block5;
                throw (ThreadDeath)t;
            }
        }
    }

    public boolean readWorkerError(Throwable t) {
        ++this.readErrorCount;
        boolean connectionOpen = false;
        try {
            connectionOpen = this.packetTracerConnection.isOpen();
        }
        catch (Throwable t2) {
            logger.error((Object)t2.toString());
            if (t2 instanceof ThreadDeath) {
                throw (ThreadDeath)t2;
            }
            connectionOpen = false;
        }
        if (!connectionOpen || this.readErrorCount > 10) {
            this.readWorker.shouldStop();
            this.emergencyShutdown();
            return false;
        }
        return true;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public IPCEventManager getEventManager() {
        return this.eventManager;
    }

    public PacketTracerConnection connection() {
        return this.packetTracerConnection;
    }

    public Pipeline pipeline() {
        return this.pipeline;
    }

    public Timer timer() {
        return this.timer;
    }

    public boolean isConnected() {
        return this.packetTracerConnection.isConnected();
    }

    public void write(LTV tlv) throws IOException {
        this.pipeline.write(tlv);
    }

    public LTV writeRead(LTV tlv) throws IOException {
        if (tlv.hasResponse()) {
            if (this.readWorker == null) {
                throw new Error("Attempt to send an LTV with a non-blocking response before readWorker initialized; LTV = " + tlv);
            }
            this.readWorker.registerRequest(tlv);
            this.pipeline.write(tlv);
            return this.readWorker.getResponse(tlv);
        }
        if (this.readWorker != null) {
            throw new Error("Attempt to send an LTV with a blocking response after readWorker initialized; LTV = " + tlv);
        }
        this.pipeline.write(tlv);
        try {
            return this.pipeline.read();
        }
        catch (InterruptedException e) {
            throw new IOException("Pipeline read was interrupted");
        }
    }

    public void handleEvent(LTV event) {
        this.eventManager.processEvent((IPCEventLTV)event);
    }

    public void handleMuMessage(LTV msg) {
    }

    public KeepAliveTask getKeepAliveTask() {
        return this.keepAliveTask;
    }

    public void handleKeepAlive(LTV msg) {
        this.keepAliveTask.receivedKeepAlive();
    }
}

